function plotgrid(xGr,yGr,clr,well,figname,figcoords)
% plotgrid(xGr,yGr, [clr [,well [,finame,figcoords]])
% plot the grid lines in color clr given the coordinates xGr yGr
% and possibly well locations in blue if well is a struct
% whose elements have fields x and y
% if figname is given with figcoords, then fig is plotted too
% if figcoords are missing xGr and yGr will be used
% TO 091201 100115

hold on

if nargin==2, clr='c'; end

if nargin>5
    xgridpic= figcoords([1 3]);
    ygridpic= figcoords([2 4]);
    gridpic = imread(figname);
    image(xgridpic,ygridpic,gridpic);
elseif nargin>4
    xgridpic= xGr([1 end]);
    ygridpic= yGr([1 end]); ygridpic=sort(ygridpic);
    gridpic = imread(figname);
    image(xgridpic,ygridpic,gridpic);
end
    

for i=1:length(xGr)
    plot(xGr([i,i]),yGr([1,end]),clr);
end

for i=1:length(yGr)
    plot(xGr([1, end]),yGr([i,i]),clr);
end

if nargin>3
    for iW=1:length(well), plot(well(iW).x,well(iW).y,'or','markerfacecolor','r'); end
end
